const { noise } = require("./perlin.js");
const { argv } = require("process");
const crypto = require("node:crypto");
const sharp = require("sharp");
const fs = require("fs");

const WIDTH = 256;
const HEIGHT = 256;

const main = async() => {
	var buffer = fs.readFileSync("tmp.webp")
	const image = await sharp(buffer, {
			webp: {
				width: WIDTH,
				height: HEIGHT,
				channels: 1
			}
		}).raw().toBuffer()
	var ivals = Uint8Array.from(image);
	console.log(ivals.length, 256 * 256 * 3)

	for (let seed = 0; seed < 65536; seed++) {
		noise.seed(seed);
		//let ox = parseInt(argv[2]);
		for (let ox = 0; ox < 256; ox++) {
			//let p = parseInt(argv[3]);
			//console.log(p);
			for (let p = 0; p < 16; p++) {
				let match = true;
				for (let y = 0; y < 40; y++) {
					for (let x = 0; x < 40; x++) {
						let v = noise.perlin2(ox + p * 0.0625 + x * 0.05, y * 0.05);
						v = (v + 1.0) * 0.5;
						v = (v * 256) | 0;
						if (ivals[(y * 256 + x) * 3] != v) {
							match = false;
							break;
						}
					}
					if (!match)
						break;
				}
				if (match)
					console.log("IDX", ox);
			}
		}
	}
}

main();
